#!/usr/bin/perl
#
# BlueLava v0.4.3
# (c) 2001-2004  Ian Wilkinson (ian@sgtwilko.f9.co.uk)
# (c) 1999  Bruce Locke  (blocke@shivan.org)
#
# Released under the GPL v2... see COPYING for details
# This software comes without any warranty...
#

#
# device.pl provides a generic interface to backend program (it may look
# like a waste now but it will pay off when it supports more programs :)
#
use IO::Socket;


BEGIN {
# includes  (you may comment out the backends you are not using)
# none
}


sub device_on
{
	local ($device) = @_;
	if ($config_settings{"backend"} eq "bottlerocket")
	{
		return(bottlerocket_action($device, "on"));
	}
	elsif ($config_settings{"backend"} eq "heyu")
	{
		return(heyu_action($device, "on"));
	}
	elsif ($config_settings{"backend"} eq "ppower")
	{
		return(ppower_action($device, "on"));
	}
	elsif ($config_settings{"backend"} eq "x10d")
	{
		return(x10d_action($device, "on"));
	}
	elsif ($config_settings{"backend"} eq "flipit")
	{
		return(flipit_action($device, "on"));
	}
	elsif ($config_settings{"backend"} eq "wish")
	{
		return(wish_action($device, "1"));

	}
        else
        {
                html_errormsg("Backend Config Error", "There is not a valid Backend configured.");
        }

}

sub device_off
{
	local ($device) = @_;

	if ($config_settings{"backend"} eq "bottlerocket")
	{
        	return(bottlerocket_action($device, "off") );
	}
	elsif ($config_settings{"backend"} eq "heyu")
	{
        	return(heyu_action($device, "off"));
	}
	elsif ($config_settings{"backend"} eq "ppower")
	{
		return(ppower_action($device, "off"));
	}
	elsif ($config_settings{"backend"} eq "x10d")
	{
        	return(x10d_action($device, "off"));
	}
	elsif ($config_settings{"backend"} eq "flipit")
	{
	       return(flipit_action($device, "off"));
	}
	elsif ($config_settings{"backend"} eq "wish")
        {
                return(wish_action($device, "0"));
        }
        else
        {
                html_errormsg("Backend Config Error", "There is not a valid Backend configured.");
        }

}

sub device_bright
{
	local ($device) = @_;

	if ($config_settings{"backend"} eq "bottlerocket")
	{
		return(bottlerocket_bright($device));
	}
	elsif ($config_settings{"backend"} eq "heyu")
	{
        	return(heyu_action_units($device, "bright"));
	}
	elsif ($config_settings{"backend"} eq "ppower")
	{
		return(ppower_action_units($device, "bright"));
	}
	elsif ($config_settings{"backend"} eq "x10d")
	{
		return(x10d_action_units($device, "bright"));
	}
	elsif ($config_settings{"backend"} eq "flipit")
	{
	       return(flipit_action_units($device, "brighten"));
	}
	elsif ($config_settings{"backend"} eq "wish")
        {
                return(wish_action($device, "bri"));
        }
        else
        {
                html_errormsg("Backend Config Error", "There is not a valid Backend configured.");
        }
}

sub device_dim
{
	local ($device) = @_;

	if ($config_settings{"backend"} eq "bottlerocket")
	{
		return(bottlerocket_dim($device));
	}
	elsif ($config_settings{"backend"} eq "heyu")
	{
        	return(heyu_action_units($device, "dim"));
	}
	elsif ($config_settings{"backend"} eq "ppower")
	{
		return(ppower_action_units($device, "dim"));
	}
        elsif ($config_settings{"backend"} eq "x10d")
        {
                return(x10d_action_units($device, "dim"));
        }
	elsif ($config_settings{"backend"} eq "flipit")
	{
	       return(flipit_action_units($device, "dim"));
	}
	elsif ($config_settings{"backend"} eq "wish")
        {
                return(wish_action($device, "dim"));
        }
        else
        {
                html_errormsg("Backend Config Error", "There is not a valid Backend configured.");
        }

}

sub device_room_action
{

local ($room, $type, $action) = @_;
local ($deviceptr, @devicelist, %devicehash, $device, $result);

$deviceptr = $config_rooms{$room};
@devicelist = @$deviceptr;

foreach $device (@devicelist)
{
	%devicehash = %$device;
	
	if ( ($devicehash{"type"} eq $type) || ($type eq "all") )
	{
		if ($action eq "on")
		{
			$result = ($result || device_on($devicehash{"id"}));
		}
		elsif ($action eq "off")
		{
			$result = ($result || (device_off($devicehash{"id"})));
		}
	}
}

return($result);

}

sub x10_status
{

local ($housecode) = @_;

if ($config_settings{"backend"} eq "bottlerocket")
{
        return(bottlerocket_x10_status($housecode) );
}
elsif ($config_settings{"backend"} eq "heyu")
{
        return(heyu_x10_status($housecode));
}
elsif ($config_settings{"backend"} eq "ppower")
{
        return(ppower_x10_status($housecode));
}


}

#
# HEYU functions
# Code specific to supporting heyu
#

# heyu

sub heyu_cmd
{
local ($params) = @_;
local ($heyu) = $config_settings{"heyu_path"}; 

return( system("$heyu $params") );
}

sub heyu_action
{
local ($device, $action) = @_;
return (heyu_cmd("turn $device $action"));
}

sub heyu_action_units
{
local ($device, $action) = @_;
local ($dim_units) = $config_settings{"dim_units"};
return( heyu_cmd ("turn $device $action $dim_units")) ;
}

sub heyu_x10_status
{
local ($housecode) = @_;
local ($heyu) = $config_settings{"heyu_path"};
open(STATUS, "$heyu info 2>&1 |")
                    || die "can't fork: $!";
    while ($val=<STATUS>) {
        if (grep { /mon/ } $val) {$state=substr($val,38,16);}
        if (grep { /House/ } $val) {$housecode=substr($val,12,1);}
    }
    close STATUS || die "bad Command: $! $?";
return ($state,$housecode);
}


#
# Bottlerocket Functions
# Code specific to supporting bottlerocket
#


sub bottlerocket_cmd
{
local ($params) = @_;
local ($bottlerocket) = $config_settings{"bottlerocket_path"};

return( system("$bottlerocket $params") );
}

sub bottlerocket_action
{
local ($device, $action) = @_;
return (bottlerocket_cmd ("$device $action"));
}

#
# The following are ugly hacks cause of bottlerocket's fucked up command
# line syntax.  While bottlerocket is nice for controlling the CM117A,
# its command line params leaves much to be desired (v0.4x)
#

sub bottlerocket_bright
{
local ($device) = @_;
local ($houseid);

bottlerocket_cmd ("$device on");
$houseid = substr($device, 0, 1);
return(bottlerocket_cmd("$houseid bright "));
}

sub bottlerocket_dim
{
 
local ($device) = @_;
local ($houseid);

bottlerocket_cmd ("$device on");
$houseid = substr($device, 0, 1);
return(bottlerocket_cmd("$houseid dim "));
}

sub bottlerocket_x10_status
{
local ($housecode) = @_;
local ($bottlerocket) = $config_settings{"bottlerocket_path"};
return ("");
}



#
# PPower functions
# Code specific to supporting ppower
#

# ppower

sub ppower_cmd
{
local ($params) = @_;
local ($ppower) = $config_settings{"ppower_path"}; 

return(system("$ppower $params"));
}

sub ppower_action
{
local ($device, $action) = @_;
return (ppower_cmd("$device:$action"));
}

sub ppower_action_units
{
local ($device, $action) = @_;
local ($dim_units) = $config_settings{"dim_units"};
return( ppower_cmd ("$device:$action:$dim_units")) ;
}

sub ppower_x10_status
{
local ($housecode) = @_;
local ($ppower) = $config_settings{"ppower_path"};
return ("");
}


#
# x10d functions
# Code specific to supporting x10d
#

# x10d 

sub x10d_cmd
{
	local ($params) = @_;
	local ($host) = $config_settings{"x10d_host"};
	local ($service) = $config_settings{"x10d_service"};
	local ($EOL) = "\015\012";
	$remote = IO::Socket::INET->new( Proto     => "tcp",
                        PeerAddr  => $host,
                        PeerPort  => $service,
                       );
	unless ($remote) { die "cannot connect to x10d daemon on $host" }
	$remote->autoflush(1);
	print $remote $params . $EOL;
	close $remote;
	return( 0 );
}

sub x10d_action
{
	local ($device, $action) = @_;
	local ($house) = substr($device,0,1);
	return (x10d_cmd("$device$house$action"));
}

sub x10d_action_units
{
	local ($device, $action) = @_;
	local ($house) =substr($device,0,1);
	local ($cmd) = $device;
	local ($dim_units) = $config_settings{"dim_units"};
	local ($count) = 0;
	while ($count<$dim_units) {
		$cmd = "$cmd $house$action";
		$count=$count+1;
	}	
	return (x10d_cmd($cmd));
}

#
# flipit functions
# Code specific to supporting flipit
#

# flipit

sub flipit_cmd
{
	local ($params) = @_;
	local ($flipit) = $config_settings{"flipit_path"};

	return(system("$flipit $params"));
}

sub flipit_action
{
	local ($device, $action) = @_;
	return (flipit_cmd("flip $device $action"));
}


sub flipit_action_units
{
	local ($device, $action) = @_;
	local ($dim_units) = $config_settings{"dim_units"};
	return( flipit_cmd ("$action $device $dim_units")) ;
}

sub flipit_x10_status
{
	local ($housecode) = @_;
	local ($flipit) = $config_settings{"flipit_path"};
	return ("");
}

# Wish functions
# Wish support (/dev/x10) added by Michiel Vreeburg 22/09/2003

sub wish_action
{
	local ($device, $action) = @_;
	local ($wish) = $config_settings{"wish_path"};
	open WISH, "> $wish/$device" or die $!;
	print WISH "$action ";
	close (WISH);
	return 0;
}


1;
 
